/**
 * First we will load all of this project's JavaScript dependencies which
 * includes Vue and other libraries. It is a great starting point when
 * building robust, powerful web applications using Vue and Laravel.
 */

require('./bootstrap');

window.Vue = require('vue');

/**
 * Vue2-DatePicker
 */

 import DatePicker from 'vue2-datepicker'
 import 'vue2-datepicker/index.css'
 Vue.use(DatePicker)
/**
 * Vue Router
 */
 import router from './routes'

 /**
  * vue moment
  */
  Vue.use(require('vue-moment'));

  /**
 * ELEMENT-UI
 */
 import ElementUI from 'element-ui';
 import 'element-ui/lib/theme-chalk/index.css';
 Vue.use(ElementUI)

  /**
 * ROLES Y PERMISOS
 */

import Auth from './Auth'

Vue.prototype.$auth = new Auth(window.user);
console.log( window.user);

  /**
 * Componente Vue-Select
 */

   import Vue from 'vue'
   import vSelect from 'vue-select'
   import 'vue-select/dist/vue-select.css';

   Vue.component('v-select', vSelect);

     /*
Importando vuelidate
 */

import Vuelidate from 'vuelidate';
Vue.use(Vuelidate)


 import VueStepWizard from 'vue-step-wizard'
 import 'vue-step-wizard/dist/vue-step-wizard.css'
 Vue.use(VueStepWizard);


// const files = require.context('./', true, /\.vue$/i)
// files.keys().map(key => Vue.component(key.split('/').pop().split('.')[0], files(key).default))

Vue.component('App', require('./components/App.vue').default);
Vue.component('Auth', require('./components/Auth.vue').default);

/**
 * Next, we will create a fresh Vue application instance and attach it to
 * the page. Then, you may begin adding components to this application
 * or customize the JavaScript scaffolding to fit your unique needs.
 */
 import VTooltip from 'v-tooltip'
 Vue.use(VTooltip);

const app = new Vue({
    el: '#app',
    router
});
