import Vue from 'vue'
import Router from 'vue-router'
Vue.use(Router)

export default new Router ({
    mode: 'history',
    linkActiveClass: 'active',
    routes: [
        {
            path: '*',
            component: require('./components/Notfound.vue').default
        },
        {
            path: '/',
            name: 'Inicio',
            component: require('./components/Bienvenida.vue').default
        },
        {
            path: '/plantilla',
            name: 'plantilla',
            component: require('./components/Plantilla.vue').default
        },
        // ACCESO AL SISTEMA
        {
            path: '/usu',
            name: 'Usuarios',
            component:  require('./components/usuarios/Usuarios.vue').default,
            beforeEnter: (to, from, next) => {
                let per = window.user.permissions.map(permission=>permission.name);
                if (per.includes('rol-per')) {
                    next();
                } else {
                    next(from.path);
                }
            }
        },
        // DATOS DE USUARIO
        {
            path: '/datosUser',
            name: 'DatosUser',
            component:  require('./components/usuarios/DatosUser.vue').default
        },
        // MODULOS DEL SISTEMA
        {
            path: '/mod',
            name: 'RegModulos',
            component:  require('./components/modulos/RegModulos.vue').default
        },
        // PERMISOS
        {
            path: '/per',
            name: 'RegPermisos',
            component:  require('./components/permisos/RegPermisos.vue').default,
            beforeEnter: (to, from, next) => {
                let per = window.user.permissions.map(permission=>permission.name);
                if (per.includes('rol-per')) {
                    next();
                } else {
                    next(from.path);
                }
            }
        },
        /******************* ROLES************************* */
        {
            path: '/lrol',
            name: 'ListRoles',
            component:  require('./components/roles/ListRoles.vue').default,
            beforeEnter: (to, from, next) => {
                let per = window.user.permissions.map(permission=>permission.name);
                if (per.includes('rol-per')) {
                    next();
                } else {
                    next(from.path);
                }
            }
        },
        {
            path: '/erol',
            name: 'EditarRol',
            component:  require('./components/roles/Editar.vue').default,
            beforeEnter: (to, from, next) => {
                let per = window.user.permissions.map(permission=>permission.name);
                if (per.includes('rol-per')) {
                    next();
                } else {
                    next(from.path);
                }
            }
        },

        {
            path: '/nrol',
            name: 'NuevoRol',
            component:  require('./components/roles/NuevoRol.vue').default,
           beforeEnter: (to, from, next) => {
                let per = window.user.permissions.map(permission=>permission.name);
                if (per.includes('rol-per')) {
                    next();
                } else {
                    next(from.path);
                }
            }
        },
        /******************************PERSONAL******************************/
        /******************* PERSONAL/PERSONAS************************* */
        {
            path: '/listPersonal',
            name: 'listPersonal',
            component:  require('./components/personal/PersonasList.vue').default,
            beforeEnter: (to, from, next) => {
            let per = window.user.permissions.map(permission=>permission.name);
                if (per.includes('persona.index')) {
                    next();
                } else {
                    next(from.path);
                }
            }
        },
        /******************* PERSONAL/DETALLE************************* */
        {
            path: '/listPersonal/:e',
            name: 'Personal_datos',
            component:  require('./components/personal/PersonasDet.vue').default,

        },
        /******************* PERSONAL/PERSONAS/CREAR************************* */
        {
            path: '/PersonaCrear',
            name: 'persona.crear',
            component:  require('./components/personal/socio.vue').default,
            beforeEnter: (to, from, next) => {
            let per = window.user.permissions.map(permission=>permission.name);
                if (per.includes('persona.crear')) {
                    next();
                } else {
                    next(from.path);
                }
            }
        },
        /******************* PERSONAL/PERSONAS/ASALARIADO/CREAR************************* */
        {
            path: '/PersonaAsalariado',
            name: 'persona.asalariado',
            component:  require('./components/personal/Asalariado.vue').default,
            beforeEnter: (to, from, next) => {
            let per = window.user.permissions.map(permission=>permission.name);
                if (per.includes('persona.asalariado')) {
                    next();
                } else {
                    next(from.path);
                }
            }
        },

        /******************* PERSONAL/PERSONAS/CONTRATO/CREAR************************* */
        {
            path: '/PersonaContrato',
            name: 'persona.contrato',
            component:  require('./components/personal/Contrato.vue').default,
            beforeEnter: (to, from, next) => {
            let per = window.user.permissions.map(permission=>permission.name);
                if (per.includes('persona.contrato')) {
                    next();
                } else {
                    next(from.path);
                }
            }
        },

        /******************* PERSONAL/EDITAR************************* */ 
        {
            path: '/editarPersonal/:codigo',
            name: 'EditarPersonal',
            component:  require('./components/personal/editPersonal.vue').default
        },

        /******************************CARGOS******************************/
        /******************* PERSONAL/PERSONAL CARGOS/ CARGOS************************* */
        {
            path: '/listCargos',
            name: 'listCargo',
            component:  require('./components/cargos/create.vue').default,
            beforeEnter: (to, from, next) => {
            let per = window.user.permissions.map(permission=>permission.name);
                if (per.includes('cargo.index')) {
                    next();
                } else {
                    next(from.path);
                }
            }
        },
        /******************* PERSONAL/PERSONAS/CARGOR************************* */
        {
            path: '/listPersCargos',
            name: 'listPersCargo',
            component:  require('./components/personalcargos/PersonasCargosList.vue').default,
            beforeEnter: (to, from, next) => {
            let per = window.user.permissions.map(permission=>permission.name);
                if (per.includes('sindicato.cargos.index')) {
                    next();
                } else {
                    next(from.path);
                }
            }
        },

        /******************* PERSONAL/PERSONAS/CREAR JEFE DE GRUPO************************* */
        {
            path: '/listJefeGrupo',
            // name: 'persona.crear',
            component:  require('./components/personal/JefesGrupo.vue').default,
            // beforeEnter: (to, from, next) => {
            // let per = window.user.permissions.map(permission=>permission.name);
            //     if (per.includes('persona.crear')) {
            //         next();
            //     } else {
            //         next(from.path);
            //     }
            // }
        },

    /************  DESDE ACA LOS MODULOS DEL SISTEMA************************* */
    /************  VARIOS/TIPO SOCIOS************************* */
        {
            path: '/tipoSocio',
            name: 'listTipoSocio',
            component:  require('./components/TipoSocio.vue').default,
            beforeEnter: (to, from, next) => {
            let per = window.user.permissions.map(permission=>permission.name);
                if (per.includes('tiposocio.index')) {
                    next();
                } else {
                    next(from.path);
                }
            }
        },
        /************  VARIOS/TIPO CUENTAS************************* */
        {
            path: '/lisCuentas',
            name: 'lisCuentas',
            component:  require('./components/Cuentas.vue').default,
            beforeEnter: (to, from, next) => {
            let per = window.user.permissions.map(permission=>permission.name);
                if (per.includes('cuentas.index')) {
                    next();
                } else {
                    next(from.path);
                }
            }
        },
        /************  VARIOS/CUENTAS************************* */
        {
            path: '/ListTipoCuentas',
            name: 'ListTipoCuentas',
            component:  require('./components/TipoCuentas.vue').default,
            beforeEnter: (to, from, next) => {
            let per = window.user.permissions.map(permission=>permission.name);
                if (per.includes('tipocuentas.index')) {
                    next();
                } else {
                    next(from.path);
                }
            }
        },
        /********************MOVILIDADES**************************/
        /************  MOVILIDADES/GRUPOS************************* */
        {
            path: '/listCars',
            name: 'listCars',
            component:  require('./components/Cars.vue').default,
            beforeEnter: (to, from, next) => {
            let per = window.user.permissions.map(permission=>permission.name);
                if (per.includes('cars.index')) {
                    next();
                } else {
                    next(from.path);
                }
            }
        },
        {
            path: '/listGrupos',
            name: 'listGrpos',
            component:  require('./components/Grupos.vue').default,
            beforeEnter: (to, from, next) => {
            let per = window.user.permissions.map(permission=>permission.name);
                if (per.includes('grupos.index')) {
                    next();
                } else {
                    next(from.path);
                }
            }
        },
        /************  MOVILIDADES/MARCA************************* */
        {
            path: '/listMarcas',
            name: 'listMarcas',
            component:  require('./components/Marca.vue').default,
            beforeEnter: (to, from, next) => {
            let per = window.user.permissions.map(permission=>permission.name);
                if (per.includes('marca.index')) {
                    next();
                } else {
                    next(from.path);
                }
            }
        },
        /************  MOVILIDADES/TIPO AUTOS************************* */
        {
            path: '/listTipoCars',
            name: 'listTipoCars',
            component:  require('./components/TipoCars.vue').default,
            beforeEnter: (to, from, next) => {
            let per = window.user.permissions.map(permission=>permission.name);
                if (per.includes('tipoauto.index')) {
                    next();
                } else {
                    next(from.path);
                }
            }
        },
         /************  MOVILIDADES/COLORES************************* */
        {
            path: '/listColores',
            name: 'listColores',
            component:  require('./components/Colores.vue').default,
            beforeEnter: (to, from, next) => {
            let per = window.user.permissions.map(permission=>permission.name);
                if (per.includes('colores.index')) {
                    next();
                } else {
                    next(from.path);
                }
            }
        },
        /********************MOVIMIENTO ECONOMICO**************************/
        /************  MOVIMIENTO ECONOMICO/HOJA DE RUTAS************************* */
        {
            path: '/hojaRutaMain',
            name: 'hojaRutaMain',
            component:  require('./components/hojaRutaMain.vue').default,
            beforeEnter: (to, from, next) => {
            let per = window.user.permissions.map(permission=>permission.name);
                if (per.includes('hojaruta.index')) {
                    next();
                } else {
                    next(from.path);
                }
            }
        },
        /******************* MOVIMIENTO ECONOMICO/LIST DEUDAS************************* */
        {
            path: '/PersonaVerHojaRuta',
            name: 'PersonaVerHojaRuta',
            component:  require('./components/deudaHojaRuta.vue').default,
           /* beforeEnter: (to, from, next) => {
            let per = window.user.permissions.map(permission=>permission.name);
                if (per.includes('hojarutapersonaver')) {
                    next();
                } else {
                    next(from.path);
                }
            }*/
        },
         /******************* MOVIMIENTO ECONOMICO/CAJA************************* */
         {
            path: '/caja',
            name: '/caja',
            component:  require('./components/Caja.vue').default,
            beforeEnter: (to, from, next) => {
            let per = window.user.permissions.map(permission=>permission.name);
                if (per.includes('caja.index')) {
                    next();
                } else {
                    next(from.path);
                }
            }
        },
        /************  MOVIMIENTO ECONOMICO/COSTO HOJA DE RUTAS************************* */
        {
            path: '/hojaRuta',
            name: 'hojaRuta',
            component:  require('./components/hojaRuta.vue').default,
            beforeEnter: (to, from, next) => {
            let per = window.user.permissions.map(permission=>permission.name);
                if (per.includes('hruta.index')) {
                    next();
                } else {
                    next(from.path);
                }
            }
        },
        /************  MOVIMIENTO ECONOMICO/FECHAS************************* */
        {
            path: '/fechas',
            name: 'fechas',
            component:  require('./components/Fechas.vue').default,
            beforeEnter: (to, from, next) => {
            let per = window.user.permissions.map(permission=>permission.name);
                if (per.includes('fechas.index')) {
                    next();
                } else {
                    next(from.path);
                }
            }
        },
    ]

})
