<?php

namespace App\Http\Controllers;

use App\Cuentas;
use App\PersonalCargo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Barryvdh\DomPDF\Facade as PDF;
use SimpleSoftwareIO\QrCode\Facades\QrCode;

class CuentasController extends Controller
{
    public function index(Request $request){
        if (!$request->ajax()) return redirect('/');
        if ($request->buscar == '') {
            $Cuentas = Cuentas::join('cuentaTipos','cuentas.cuentaTipo_id','cuentaTipos.id')
            ->select('cuentas.id','cuentaTipos.id as idcuentaTipos','cuentaTipos.cuentaTipo','cuentas.cuentaTipo_id','cuentas.descripcion','cuentas.obs','cuentas.estado')
            ->orderBy('cuentas.descripcion','asc')
            ->paginate(10);
        } else {
            $Cuentas = Cuentas::join('cuentaTipos','cuentas.cuentaTipo_id','cuentaTipos.id')
            ->select('cuentas.id','cuentaTipos.id as idcuentaTipos','cuentaTipos.cuentaTipo','cuentas.cuentaTipo_id','cuentas.descripcion','cuentas.obs','cuentas.estado')
            ->where('descripcion','LIKE','%'.$request->buscar.'%')
            ->orderBy('descripcion')
            ->paginate(10);
        }
        return response()->json([
            'pagination' => [
                'total'         => $Cuentas->total(),
                'current_page'  => $Cuentas->currentPage(),
                'per_page'      => $Cuentas->perPage(),
                'last_page'     => $Cuentas->lastPage(),
                'from'          => $Cuentas->firstItem(),
                'to'            => $Cuentas->lastItem(),

            ],
            'Cuentas' => $Cuentas
        ]);
    }

    public function selectCuentas(Request $request){
        if(!$request->ajax()) return view('/');
        $id = $request->tipoCuenta_id;
       // return var_dump($id );
        $Cuentas = Cuentas::select('cuentas.id','cuentas.cuentaTipo_id','cuentas.descripcion','cuentas.obs','cuentas.estado')
        ->where('cuentas.estado',1)
        ->where('cuentas.cuentaTipo_id',$id)
        ->orderBy('cuentas.descripcion','asc')
        ->get();
        return response()->json($Cuentas);
    }

    public function store(Request $request){
        // return response()->json($request);
        if(!$request->ajax()) return redirect('/');
        $descripcion = $request->descripcion;
        $Cuentas = Cuentas::select('descripcion')
        ->where('descripcion', $descripcion)
        ->first();
        //return response()->json($doc);
        if(!empty($Cuentas)){
            return response()->json("existe");
              //return "existe";
        } else {
            $Cuentas = new Cuentas();
            $Cuentas->cuentaTipo_id = $request->lisTipCuenta;
            $Cuentas->descripcion = $request->descripcion;
            $val = $request->observacion;

            if($val == ''){
                $val = 'NINGUNO';
            }
            else{
                $val = $request->observacion;
            }
            $Cuentas->obs = $val;
            $Cuentas->estado = '1';
            $Cuentas->user_id = Auth::user()->id;
            $Cuentas->save();
        }
    }

    public function update(Request $request){
        if (!$request->ajax()) return redirect('/');
        //return response()->json($request);
        $id = $request->id;
        // return var_dump($id);
        $descripcion = $request->descripcion;
        $Cuentas = Cuentas::select('id','descripcion')
        ->where('descripcion', $descripcion)
        ->whereNotIn('id', [$id])
        ->first();
        if(!empty($Cuentas)){
            return response()->json("existe");
             //return "existe";
        } else {
            $Cuentas = Cuentas::findOrFail($request->id);
            $Cuentas->cuentaTipo_id = $request->lisTipCuenta_edit;
            $Cuentas->descripcion = $request->descripcion;
            $val = $request->observacion;

            if($val == ''){
                $val = 'NINGUNA';
            }
            else{
                $val = $request->observacion;
            }
            $Cuentas->obs = $val;
            $Cuentas->estado = '1';
            $Cuentas->user_id = Auth::user()->id;
            $Cuentas->save();
        }
    }

    public function stateChange(Request $request){
        if(!$request->ajax()) return redirect('/');
        $Cuentas           = Cuentas::findOrFail($request->id);
        $Cuentas->estado   = $request->estado;
        $Cuentas->save();
    }

    public function reporteCuentas(){
        $Cuentas = Cuentas::join('cuentaTipos','cuentas.cuentaTipo_id','cuentaTipos.id')
        ->select('cuentas.id','cuentaTipos.id as idcuentaTipos','cuentaTipos.cuentaTipo','cuentas.cuentaTipo_id','cuentas.descripcion','cuentas.obs','cuentas.estado')
        ->orderBy('cuentas.descripcion', 'desc')
        ->get();

        $cargo1 = PersonalCargo::join('personals','sindicatoCargos.per_codigo','personals.per_codigo')
        ->join('cargos','sindicatoCargos.cargo_id','cargos.id')
        ->select('cargos.descripcion',
        'personals.per_paterno as paterno','personals.per_materno as materno','personals.per_nombre as nombre')
        ->where('sindicatoCargos.estado',1)
        ->where('cargos.id',1)
        ->first();

        $total = DB::table('cuentas')
        ->select(DB::raw('count(*) as count'))
        ->where('estado',1)
        ->first()
        ->count;

        $meses = array("ENERO","FEBRERO","MARZO","ABRIL","MAYO","JUNIO","JULIO","AGOSTO","SEPTIEMBRE","OCTUBRE","NOVIEMBRE","DICIEMBRE");
        $fecha_emision = date('d')." DE ".$meses[date('n')-1]." DEL ".date('Y');
        $qr = QrCode::encoding('UTF-8')->size(100)->generate("SINDICATO DE TRANSPORTE 16 DE JULIO TRUFI 7\nTOTAL REGISTROS: $total\nFECHA: $fecha_emision");
        $codigo = $qr;
        $pdf = PDF::loadView('reportes.cuentas',['cuentas'=>$Cuentas,
                            'cargos'=>$cargo1,
                            'qr'=>$codigo])
        ->setPaper('letter', 'portrait');

        return $pdf->stream('Cargos.pdf');
    }
}
