<?php

namespace App\Http\Controllers;

use App\Fecha;
use App\hojaGenerada;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class FechaController extends Controller
{
    public function index(Request $request){
        if (!$request->ajax()) return redirect('/');
        if ($request->buscar == '') {
            $fechas = Fecha::select('fechas.id','fechas.fecha','fechas.fechaGenerada','fechas.gestionInicio','fechas.mesInicio',
            'fechas.fechaInicio','fechas.fechaFinal','fechas.gestionFinal','fechas.mesFinal','fechas.semana','fechas.mes','fechas.gestion',
            'fechas.estado','fechas.costoHRSocio_id','fechas.costoHRAsalariado_id','fechas.user_id')
            ->where('fechas.estado','1')
            ->orderBy('fechas.id','desc')
            ->paginate(10);
        } else {
            $fechas = Fecha::select('fechas.id','fechas.fecha','fechas.fechaGenerada','fechas.gestionInicio','fechas.mesInicio',
            'fechas.fechaInicio','fechas.fechaFinal','fechas.gestionFinal','fechas.mesFinal','fechas.semana','fechas.mes','fechas.gestion',
            'fechas.estado','fechas.costoHRSocio_id','fechas.costoHRAsalariado_id','fechas.user_id')
            ->where('fechas.fechaInicio','LIKE','%'.$request->buscar.'%')
             ->orderBy('fechas.id','desc')
            ->paginate(10);
        }
        return response()->json([
            'pagination' => [
                'total'         => $fechas->total(),
                'current_page'  => $fechas->currentPage(),
                'per_page'      => $fechas->perPage(),
                'last_page'     => $fechas->lastPage(),
                'from'          => $fechas->firstItem(),
                'to'            => $fechas->lastItem(),

            ],
            'fechas' => $fechas
        ]);
    }

    public function store(Request $request){
       // return response()->json($request);
        if(!$request->ajax()) return redirect('/');

        $fechaInicio = $request->fechaInicio;
        $fechaFinal = $request->fechaFinal;
        $añoInicio = date('Y',strtotime($fechaInicio));
        $mesInicio = date('m',strtotime($fechaInicio));
        $añoFin = date('Y',strtotime($fechaFinal));
        $mesFin = date('m',strtotime($fechaFinal));
        $gestion = date('Y');
        $fecha = Fecha::select('fechaInicio','fechaFinal')
        ->where('fechaInicio', $fechaInicio)
        ->where('fechaFinal', $fechaFinal)
        ->first();

        $personas = DB::table('inscriptions')
        ->join('personals','inscriptions.persona_id','personals.per_codigo')
        ->join('tipoSocios','personals.tipoSocio_id','tipoSocios.id')
        ->select('personals.per_codigo','inscriptions.id as inscripcion_id','personals.tipoSocio_id')
        ->where('inscriptions.estado',1)->get();

       // return response()->json($personas);
        if(!empty($fecha)){
            return response()->json(400);
              //return "existe";
        } else {
            try {
                DB::beginTransaction();
                $fecha = new Fecha();
                $fecha->gestionInicio = $añoInicio;
                $fecha->mesInicio = $mesInicio;
                $fecha->fechaInicio = $request->fechaInicio;
                $fecha->fechaFinal = $request->fechaFinal;
                $fecha->gestionFinal = $añoFin;
                $fecha->mesFinal = $mesFin;
                $fecha->semana = $request->semana;
                $fecha->mes = $request->mes;
                $fecha->gestion = $gestion;
                $fecha->estado = '1';
                $fecha->costoHRSocio_id = $request->costoHRSocio_id;
                $fecha->costoHRAsalariado_id = $request->costoHRAsalariado_id;
                $fecha->user_id = Auth::user()->id;
                $fecha->save();

                foreach($personas as $persona){
                    //return var_dump($persona);
                    $hojaGenerada = new hojaGenerada();
                    $hojaGenerada->per_codigo = $persona->per_codigo;
                    $hojaGenerada->tipoSocio_id = $persona->tipoSocio_id;
                    $hojaGenerada->fecha_id =   $fecha->id;
                    $hojaGenerada->inscripcion_id = $persona->inscripcion_id;
                    $hojaGenerada->estado = 1;
                    $hojaGenerada->user_id = Auth::user()->id;
                    $hojaGenerada->save();

                }
                DB::commit();
                return response()->json(200);
              } catch (\Exception $e) {
                 DB::rollBack();
                 return response()->json(404);
              }
        }
    }

    public function update(Request $request){
        if (!$request->ajax()) return redirect('/');
      // return response()->json($request);
        $id = $request->id;
        $fechaInicio = $request->fechaInicio;
        $fechaFinal = $request->fechaFinal;
        $añoInicio = date('Y',strtotime($fechaInicio));
        $mesInicio = date('m',strtotime($fechaInicio));
        $añoFin = date('Y',strtotime($fechaFinal));
        $mesFin = date('m',strtotime($fechaFinal));
        $gestion = date('Y');
        $fecha = Fecha::select('fechaInicio','fechaFinal')
        ->where('fechaInicio', $fechaInicio)
        ->where('fechaFinal', $fechaFinal)
        ->whereNotIn('id', [$id])
        ->first();
        if(!empty($fecha)){
            return response()->json("existe");
             //return "existe";
        } else {
            $fecha = Fecha::findOrFail($request->id);
            $fecha->gestionInicio = $añoInicio;
            $fecha->mesInicio = $mesInicio;
            $fecha->fechaInicio = $request->fechaInicio;
            $fecha->fechaFinal = $request->fechaFinal;
            $fecha->gestionFinal = $añoFin;
            $fecha->mesFinal = $mesFin;
            $fecha->semana = $request->semana;
            $fecha->mes = $request->mes;
            $fecha->gestion = $gestion;
            $fecha->estado = '1';
            $fecha->user_id = Auth::user()->id;
            $fecha->save();
        }
    }

    public function stateChange(Request $request){
        if(!$request->ajax()) return redirect('/');
        $fecha           = Fecha::findOrFail($request->id);
        $fecha->estado   = $request->estado;
        $fecha->save();
    }

    public function selectFechas(){
        $fechas = DB::table('fechas')
                ->select('fechas.id','fechas.fechaInicio','fechas.fechaFinal'
                 )
                ->where('fechas.estado',1)
                ->orderBy('fechas.id','desc')
                ->get();
            return response()->json($fechas);
    }
}
