<?php

namespace App\Http\Controllers;

use App\Marca;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class MarcaController extends Controller
{
    public function index(Request $request){
        if (!$request->ajax()) return redirect('/');
        if ($request->buscar == '') {
            $marcas = Marca::orderBy('marca')
            ->paginate(10);
        } else {
            $marcas = Marca::where('marca','LIKE','%'.$request->buscar.'%')
                        ->orderBy('marca')
                        ->paginate(10);
        }
        return response()->json([
            'pagination' => [
                'total'         => $marcas->total(),
                'current_page'  => $marcas->currentPage(),
                'per_page'      => $marcas->perPage(),
                'last_page'     => $marcas->lastPage(),
                'from'          => $marcas->firstItem(),
                'to'            => $marcas->lastItem(),

            ],
            'marcas' => $marcas
        ]);
    }

    public function store(Request $request){
        // return response()->json($request);
        if(!$request->ajax()) return redirect('/');
        $marca = $request->marca;
        $marca = Marca::select('marca')
        ->where('marca', $marca)
        ->first();
        //return response()->json($doc);
        if(!empty($marca)){
            return response()->json("existe");
              //return "existe";
        } else {
            $marca = new Marca();
            $marca->marca = $request->marca;
            $marca->obs = $request->observacion;
            $marca->estado = '1';
            $marca->user_id = Auth::user()->id;
            $marca->save();
        }
    }

    public function update(Request $request){
        if (!$request->ajax()) return redirect('/');
        //return response()->json($request);
        $id = $request->id;
        $marca = $request->marca;
        $marca = Marca::select('id','marca')
        ->where('marca', $marca)
        ->whereNotIn('id', [$id])
        ->first();
        if(!empty($marca)){
            return response()->json("existe");
             //return "existe";
        } else {
            $marca = Marca::findOrFail($request->id);
            $marca->marca = $request->marca;
            $marca->obs = $request->observacion;
            $marca->estado = '1';
            $marca->user_id = Auth::user()->id;
            $marca->save();
        }
    }

    public function stateChange(Request $request){
        if(!$request->ajax()) return redirect('/');
        $marca           = Marca::findOrFail($request->id);
        $marca->estado   = $request->estado;
        $marca->save();
    }

    public function ComboSelectMarca(Request $request){
        if(!$request->ajax()) return view('/');

        $marcas = DB::table('marcas')
                            ->select('id as marca_id','marca')
                            ->where('estado','1')
                            ->orderBy('marca','asc')
                            ->get();
        return response()->json($marcas);
    }
}
