<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Auth;

class PermisosController extends Controller
{
    public function ListarPermisos(Request $request)
    {

        $buscar = $request->buscar;

        if ($buscar=='') {
            $permisos = DB::table('permissions as per')
                ->join('modulos as mod', 'per.mod_cod','mod.id')
                ->select('per.name as nombre','per.detalle as detalle','per.estado as estado','per.id as id',
                        'mod.nombre as modulo','per.mod_cod')
                ->orderBy('mod.nombre')
                ->paginate(10);
        } else {
            $permisos = DB::table('permissions as per')
                ->join('modulos as mod', 'per.mod_cod','mod.id')
                ->select('per.name as nombre','per.detalle as detalle','per.estado as estado','per.id as id',
                        'mod.nombre as modulo','per.mod_cod')
                ->where(function($q) use ($buscar) {
                    $q->where('per.name', 'LIKE', '%'.$buscar.'%')
                    ->orwhere('per.detalle', 'LIKE', '%'.$buscar.'%')
                    ->orwhere('mod.nombre', 'LIKE', '%'.$buscar.'%');
                })
                ->orderBy('mod.id', 'desc')->paginate(10);
        }

        return [
            'pagination' => [
                'total'          => $permisos->total(),
                'current_page'   => $permisos->currentPage(),
                'per_page'       => $permisos->perPage(),
                'last_page'      => $permisos->lastPage(),
                'from'           => $permisos->firstItem(),
                'to'             => $permisos->lastItem(),
            ],
            'permisos'  => $permisos
        ];
    }

    public function registrarPermiso(Request $request)
    {

        if (Permission::where('name',$request->nombre)->first()) {
            return response()->json(['code'=> 400]);

        } else {
            Permission::create([
                'mod_cod' => $request->modulo,
                'name' => $request->nombre,
                'guard_name' => 'web',
                'detalle' => $request->detalle,
                'estado' => $request->estado,
                'sysuser' => Auth::user()->id,
            ]);
            return response()->json(['code'=> 200]);
        }
    }

    public function desactivarPermiso(Request $request)
    {
        $permiso = Permission::findOrFail($request->id);
        $permiso->estado = '0';
        $permiso->save();
    }

    public function activarPermiso(Request $request)
    {
        $permiso = Permission::findOrFail($request->id);
        $permiso->estado = '1';
        $permiso->save();
    }

    public function actualizarPermiso(Request $request)
    {
        $permiso = Permission::where('id',$request->id)
            ->first();

        $permiso->update([
        'mod_cod' => $request->modulo,
        'name' => $request->nombre,
        'detalle' => $request->detalle,
        'sysuser' => Auth::user()->nick,
        ]);
        return response()->json($permiso);

    }

    public function ListPermisos()
    {
        $permisos = DB::table('permissions as p')
        ->join('modulos as m', 'p.mod_cod','m.id')
        ->select('p.id','p.name','p.detalle','m.nombre as modulo')
        ->get();

        return response()->json($permisos);
    }
}
