<?php

namespace App\Http\Controllers;

use App\Personal;
use App\Car;
use App\PersonalCargo;
use App\Inscripction;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Barryvdh\DomPDF\Facade as PDF;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Illuminate\Support\Str;

class PersonalController extends Controller
{
    public function index(Request $request){
        if(!$request->ajax()) return redirect('/');
        $buscar = $request->buscar;

        if($buscar == ''){
            $personal = DB::table('personals')
                ->join('tipoSocios','personals.tipoSocio_id','tipoSocios.id')

                ->select('personals.per_codigo',
                        DB::raw("CONCAT(personals.per_paterno,' ',personals.per_materno,' ',personals.per_nombre) as completo"),
                        'personals.per_paterno',
                        'personals.per_materno',
                        'personals.per_nombre',
                        'personals.per_ci',
                        'personals.per_expedido',
                        'personals.per_celular',
                        'tipoSocios.descripcion')
                ->where('personals.estado',1)
                ->where('tipoSocios.estado',1)
                ->orderBy('personals.per_paterno','asc')
                ->paginate(10);
        }else{
            $personal = DB::table('personals')
                ->join('tipoSocios','personals.tipoSocio_id','tipoSocios.id')

                ->select('personals.per_codigo',
                    DB::raw("CONCAT(personals.per_paterno,' ',personals.per_materno,' ',personals.per_nombre) as completo"),
                    'personals.per_paterno',
                    'personals.per_materno',
                    'personals.per_nombre',
                    'personals.per_ci',
                    'personals.per_expedido',
                    'personals.per_celular',
                    'tipoSocios.descripcion')
                ->where('personals.estado',1)
                ->where('tipoSocios.estado',1)
                ->where(function ( $query ) use ($buscar) {
                    $query->orWhere('per_celular','like',$buscar.'%')
                            ->orWhere('per_ci','like',$buscar.'%')
                            ->orWhere('per_nombre','like',$buscar.'%')
                            ->orWhere('per_paterno','like',$buscar.'%')
                            ->orWhere('per_materno','like',$buscar.'%')
                            ->orWhere( DB::raw("CONCAT(per_paterno,' ',per_materno,' ',per_nombre)"),'like',$buscar.'%');
                })
                ->orderBy('personals.per_paterno','asc')
                ->take(1)
                ->paginate(10);
        }

        return [
            'pagination' => [
                'total'         => $personal->total(),
                'current_page'  => $personal->currentPage(),
                'per_page'      => $personal->perPage(),
                'last_page'     => $personal->lastPage(),
                'from'          => $personal->firstItem(),
                'to'            => $personal->lastItem(),

            ],
            'personal' => $personal
        ];
        // return response()->json($personal);
    }

    public function MainList(Request $request){
        if(!$request->ajax()) return redirect('/');
        $buscar = $request->buscar;

        if($buscar == ''){
            $personal = DB::table('personals')
                ->join('tipoSocios','personals.tipoSocio_id','tipoSocios.id')

                ->select('personals.per_codigo',
                        DB::raw("CONCAT(personals.per_paterno,' ',personals.per_materno,' ',personals.per_nombre) as completo"),
                        'personals.per_paterno',
                        'personals.per_materno',
                        'personals.per_nombre',
                        'personals.per_ci',
                        'personals.per_expedido',
                        'personals.per_celular',
                        'tipoSocios.descripcion')
                ->whereIn('personals.tipoSocio_id',[1,2])
                ->where('personals.estado',1)
                ->where('tipoSocios.estado',1)
                ->orderBy('personals.per_paterno','asc')
                ->paginate(10);
        }else{
            $personal = DB::table('personals')
                ->join('tipoSocios','personals.tipoSocio_id','tipoSocios.id')

                ->select('personals.per_codigo',
                    DB::raw("CONCAT(personals.per_paterno,' ',personals.per_materno,' ',personals.per_nombre) as completo"),
                    'personals.per_paterno',
                    'personals.per_materno',
                    'personals.per_nombre',
                    'personals.per_ci',
                    'personals.per_expedido',
                    'personals.per_celular',
                    'tipoSocios.descripcion')
                ->whereIn('personals.tipoSocio_id',[1,2])
                ->where('personals.estado',1)
                ->where('tipoSocios.estado',1)
                ->where(function ( $query ) use ($buscar) {
                    $query->orWhere('per_celular','like',$buscar.'%')
                            ->orWhere('per_ci','like',$buscar.'%')
                            ->orWhere('per_nombre','like',$buscar.'%')
                            ->orWhere('per_paterno','like',$buscar.'%')
                            ->orWhere('per_materno','like',$buscar.'%')
                            ->orWhere( DB::raw("CONCAT(per_paterno,' ',per_materno,' ',per_nombre)"),'like',$buscar.'%');
                })
                ->orderBy('personals.per_paterno','asc')
                ->take(1)
                ->paginate(10);
        }

        return [
            'pagination' => [
                'total'         => $personal->total(),
                'current_page'  => $personal->currentPage(),
                'per_page'      => $personal->perPage(),
                'last_page'     => $personal->lastPage(),
                'from'          => $personal->firstItem(),
                'to'            => $personal->lastItem(),

            ],
            'personal' => $personal
        ];
        // return response()->json($personal);
    }

    public function ListarPersonal() {
        $datos = DB::table('personal_escalafones as pe')
            ->join('personals as p','pe.per_codigo','p.per_codigo')
            ->join('grados as g','pe.gra_cod','g.id')
            ->join('personal_estudios as pest','p.per_codigo','pest.per_codigo')
            ->join('estudios as e','pest.est_cod','e.id')
            ->join('personal_situaciones as persit','persit.per_codigo','p.per_codigo')
            ->join('situaciones as sit','persit.sit_cod','sit.id')
            ->join('subsituaciones as subsit','persit.subsit_cod','subsit.id')
            ->join('detalle_situaciones as detsit','persit.detsit_cod','detsit.id')
            ->join('escalafones as esca','pe.esca_cod','esca.id')
            ->join('subescalafones as subesca','pe.subesc_cod','subesca.id')
            ->select('p.per_codigo as codigo','p.per_nombre as nombre','p.per_paterno as paterno','p.per_materno as materno', 'g.abreviatura as grado','e.abreviatura as abreviatura')
            ->where('pe.estado',1)
            ->where('esca.estado',1)
            ->where('pest.estado',1)
            ->where('persit.estado',1)
            ->where('persit.sit_cod',1)
            ->where('g.fuerza','FAB')
            ->orderBy('esca.id','asc')
            ->orderBy('subesca.orden','asc')
            ->orderBy('g.divGra','asc')
            ->get();

        $data = [];

        foreach ($datos as $key => $value) {
            $data[$key] = [
                'id' => $value->codigo,
                'nombre' => $value->grado.' '.$value->abreviatura.' '.$value->nombre.' '.$value->paterno.' '.$value->materno
            ];
        }
        return response()->json($data);
    }

    public function comboSelectPersonal(Request $request){
        if(!$request->ajax()) return redirect('/');
        $personal = DB::table('personals')
        ->select('personals.per_codigo',
                DB::raw("CONCAT(personals.per_paterno,' ',personals.per_materno,' ',personals.per_nombre,' ',personals.per_ci) as completo"),
                'personals.per_paterno',
                'personals.per_materno',
                'personals.per_nombre',
                'personals.per_ci',
                'personals.tipoSocio_id')
        ->where('personals.estado',1)
        ->orderBy('personals.per_paterno','asc')
        ->get();
        return response()->json($personal);
    }

    public function listarPersonalUsuarios(){
        $datos = DB::table('personal_escalafones as pe')
            ->join('personals as p','pe.per_codigo','p.per_codigo')
            ->join('grados as g','pe.gra_cod','g.id')
            ->join('personal_estudios as pest','p.per_codigo','pest.per_codigo')
            ->join('estudios as e','pest.est_cod','e.id')
            ->join('personal_situaciones as persit','persit.per_codigo','p.per_codigo')
            ->join('situaciones as sit','persit.sit_cod','sit.id')
            ->join('subsituaciones as subsit','persit.subsit_cod','subsit.id')
            ->join('detalle_situaciones as detsit','persit.detsit_cod','detsit.id')
            ->join('escalafones as esca','pe.esca_cod','esca.id')
            ->join('subescalafones as subesca','pe.subesc_cod','subesca.id')
            ->join('personal_destinos as pdest','pdest.per_codigo','p.per_codigo')
            ->join('nivel2_destinos as dest2','pdest.d2_cod','dest2.id')
            ->join('entidades as ent','ent.id_destino','dest2.id')
            ->select('p.per_codigo as codigo','p.per_nombre as nombre','p.per_paterno as paterno','p.per_materno as materno', 'g.abreviatura as grado','e.abreviatura as abreviatura')
            ->where('pe.estado',1)
            ->where('pdest.estado',1)
            ->where('esca.estado',1)
            ->where('pest.estado',1)
            ->where('persit.estado',1)
            ->where('persit.sit_cod',1)
            ->where('g.fuerza','FAB')
            ->orderBy('esca.id','asc')
            ->orderBy('subesca.orden','asc')
            ->orderBy('g.divGra','asc')
            ->get();

        $data = [];

        foreach ($datos as $key => $value) {
            $data[$key] = [
                'id' => $value->codigo,
                'nombre' => $value->grado.' '.$value->abreviatura.' '.$value->nombre.' '.$value->paterno.' '.$value->materno
            ];
        }
        return response()->json($data);
    }

    public function datosPersonalesRuta(Request $request){
        $id = $request->per_codigo;
        $dato = DB::table('personals')
        ->join('tipoSocios','personals.tipoSocio_id','tipoSocios.id')
        ->join('lineas','personals.linea_id','lineas.id')
        ->join('grupos','personals.grupo_id','grupos.id')
        ->join('inscriptions','personals.per_codigo','inscriptions.persona_id')
        ->select('personals.per_codigo','personals.per_nombre as nombre','personals.per_paterno as paterno', 'personals.per_foto as foto',
        'personals.per_materno as materno','personals.per_ci as identidad','personals.per_expedido as expedido','personals.tipoSocio_id',
        'tipoSocios.descripcion as socio','lineas.descripcion as linea','grupos.detalle as grupo','inscriptions.id as inscripcion_id')
        ->where('personals.per_codigo',$id)
        ->where('tipoSocios.estado',1)
        ->where('lineas.estado',1)
        ->where('grupos.estado',1)
        ->first();

        return response()->json($dato);
    }

    public function DatosPersonalesAcceso(Request $request){
        $percodigo = $request->percodigo;
        $datos = DB::table('personals')

            ->select('personals.per_codigo as percodigo','personals.per_foto as foto','personals.per_nombre as nombre',
            'personals.per_paterno as paterno','personals.per_materno as materno', 'personals.per_ci as ci',
                        'personals.per_expedido as expedido', 'personals.per_mail as email' )

            ->where('personals.per_codigo',$percodigo)
            ->where('personals.estado',1)
            ->first();

            return response()->json($datos);
    }

    public function RegistrarPersonal(Request $request) {
        $fecha = date('Y-m-d');
        try {
             DB::beginTransaction();

            $persona = Personal::select('per_ci')->where('per_ci',$request->data['ci'])->first();
            if(!empty($persona)){
                return response()->json("per_ci");
                //return "existe";
            }
            $car = Car::select('placa')->where('placa',$request->data['placa'])->first();
            if(!empty($car)){
                return response()->json("car");
                //return "existe";
            }
             if ($request->data['foto'] != "") {
                 $exploded = explode(',', $request->data['foto']);
                 $decoded = base64_decode($exploded[1]);
                 if (Str::contains($exploded[0], 'jpeg')) {
                     $extension = 'jpg';
                 } else {
                     $extension = 'png';
                 }
                 $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
                 $charactersLength = strlen($characters);
                 $randomString = '';
                 for ($i=0; $i < 10; $i++) {
                    $randomString .= $characters[rand(0,$charactersLength - 1)];
                 }
                 $fileName = $randomString.($request->data['ci']).$randomString.'.'.$extension;
                 $path = public_path().'/img/personal/'.$fileName;
                 file_put_contents($path, $decoded);

             } else {
                 $fileName = 'avatar.jpg';
             }
             $personal = Personal::create([
                'per_paterno' => strtoupper($request->data['paterno']),
                'per_materno' => strtoupper($request->data['materno']),
                'per_nombre' => strtoupper($request->data['nombre']),
                'per_fecha_nacimiento' => $request->data['fechaNacimiento'],
                'per_estado_civil' => $request->data['estadoCivil'],
                'per_sexo' => strtoupper($request->data['genero']),
                'per_ci' => $request->data['ci'],
                'per_expedido' => $request->data['expedido'],
                'per_licencia' => $request->data['per_licencia'],
                'categoria_id' => $request->data['categoria_id']['categoria_id'],
                'tipoSocio_id' => 1,
                'linea_id' => $request->data['linea_id']['linea_id'],
                'grupo_id' => $request->data['grupo_id']['grupo_id'],
                'per_celular' => $request->data['celular'],
                'per_mail' => $request->data['email'],
                'per_ciudad' => strtoupper($request->data['ciudad']),
                'per_zona' => strtoupper($request->data['zona']),
                'per_calle' => strtoupper($request->data['calle']),
                'per_puerta' => $request->data['puerta'],
                'per_foto' => $fileName,
                'per_observaciones' => strtoupper($request->data['observacion']),
                'estado' => 1,
                'sysuser' => Auth::user()->id,
                'fechaRegistro' => $fecha
             ]);
            $percodigo = $personal->per_codigo;
            $car = Car::create([
                'per_codigo' => $percodigo,
                'marca_id' => $request->data['marca_id']['marca_id'],
                'tipo_id' => $request->data['tipo_id']['tipoCar_id'],
                'color_id' => $request->data['color_id']['color_id'],
                'linea_id' => $request->data['linea_id']['linea_id'],
                'grupo_id' => $request->data['grupo_id']['grupo_id'],
                'placa' => strtoupper($request->data['placa']),
                'rua' => strtoupper($request->data['rua']),
                'modelo' => $request->data['modelo'],
                'fechaRegistro' =>$fecha, // $request->data['fechaRegistro'],
                'estado' => 1,
                'user_id' => Auth::user()->id
            ]);
            $car_id = $car->id;
            $inscripcion = Inscripction::create([
                'persona_id'    => $percodigo,
                'car_id'        => $car_id,
                'grupo_id'      => $request->data['grupo_id']['grupo_id'],
                'estado'        => 1,
                'user_id' => Auth::user()->id
            ]);
            DB::commit();
            return response()->json(200);
          } catch (\Exception $e) {
             DB::rollBack();
             return response()->json(400);
          }
        //return response()->json($request);
        return response()->json(200);
    }

    public function RegistrarAsalariado(Request $request) {
       // return var_dump($request->data['fechaIngreso']['id']);
        $fecha = date('Y-m-d');
        try {
            DB::beginTransaction();

            $persona = Personal::select('per_ci')->where('per_ci',$request->data['ci'])->first();
            if(!empty($persona)){
                return response()->json("per_ci");
                //return "existe";
            }

            if ($request->data['foto'] != "") {
                $exploded = explode(',', $request->data['foto']);
                $decoded = base64_decode($exploded[1]);
                if (Str::contains($exploded[0], 'jpeg')) {
                    $extension = 'jpg';
                } else {
                    $extension = 'png';
                }
                $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
                $charactersLength = strlen($characters);
                $randomString = '';
                for ($i=0; $i < 10; $i++) {
                $randomString .= $characters[rand(0,$charactersLength - 1)];
                }
                $fileName = $randomString.($request->data['ci']).$randomString.'.'.$extension;
                $path = public_path().'/img/personal/'.$fileName;
                file_put_contents($path, $decoded);

            }   else {
                    $fileName = 'avatar.jpg';
            }
            $personal = Personal::create([
                'per_paterno' => strtoupper($request->data['paterno']),
                'per_materno' => strtoupper($request->data['materno']),
                'per_nombre' => strtoupper($request->data['nombre']),
                'per_fecha_nacimiento' => $request->data['fechaNacimiento'],
                'per_estado_civil' => $request->data['estadoCivil'],
                'per_sexo' => strtoupper($request->data['genero']),
                'per_ci' => $request->data['ci'],
                'per_expedido' => $request->data['expedido'],
                'per_licencia' => $request->data['per_licencia'],
                'categoria_id' => $request->data['categoria_id']['categoria_id'],
                'tipoSocio_id' => 2,
                'linea_id' => $request->data['linea_id']['linea_id'],
                'grupo_id' => $request->data['grupo_id']['grupo_id'],
                'per_celular' => $request->data['celular'],
                'per_mail' => $request->data['email'],
                'per_ciudad' => strtoupper($request->data['ciudad']),
                'per_zona' => strtoupper($request->data['zona']),
                'per_calle' => strtoupper($request->data['calle']),
                'per_puerta' => $request->data['puerta'],
                'per_foto' => $fileName,
                'per_observaciones' => strtoupper($request->data['observacion']),
                'estado' => 1,
                'sysuser' => Auth::user()->id,
                'fechaRegistro' => $fecha
            ]);
            $percodigo = $personal->per_codigo;
            $inscripcion = Inscripction::create([
                 'persona_id'    => $percodigo,
                 'car_id'        => NULL,
                 'grupo_id'      => $request->data['grupo_id']['grupo_id'],
                 'estado'        => 1,
                 'user_id' => Auth::user()->id
            ]);
        DB::commit();
            return response()->json(200);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json(400);
        }
        //return response()->json($request);
        return response()->json(200);
    }

    public function RegistrarContrato(Request $request) {
        // return var_dump($request->data['fechaIngreso']['id']);
        $fecha = date('Y-m-d');
        try {
            DB::beginTransaction();

            $persona = Personal::select('per_ci')->where('per_ci',$request->data['ci'])->first();
            if(!empty($persona)){
                return response()->json("per_ci");
                //return "existe";
            }

            if ($request->data['foto'] != "") {
                $exploded = explode(',', $request->data['foto']);
                $decoded = base64_decode($exploded[1]);
                if (Str::contains($exploded[0], 'jpeg')) {
                    $extension = 'jpg';
                } else {
                    $extension = 'png';
                }
                $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
                $charactersLength = strlen($characters);
                $randomString = '';
                for ($i=0; $i < 10; $i++) {
                $randomString .= $characters[rand(0,$charactersLength - 1)];
                }
                $fileName = $randomString.($request->data['ci']).$randomString.'.'.$extension;
                $path = public_path().'/img/personal/'.$fileName;
                file_put_contents($path, $decoded);

            }  else {
                $fileName = 'avatar.jpg';
            }
            $personal = Personal::create([
                'per_paterno' => strtoupper($request->data['paterno']),
                'per_materno' => strtoupper($request->data['materno']),
                'per_nombre' => strtoupper($request->data['nombre']),
                'per_fecha_nacimiento' => $request->data['fechaNacimiento'],
                'per_estado_civil' => $request->data['estadoCivil'],
                'per_sexo' => strtoupper($request->data['genero']),
                'per_ci' => $request->data['ci'],
                'per_expedido' => $request->data['expedido'],
                'per_licencia' => $request->data['ci'],
                'categoria_id' => NULL,
                'tipoSocio_id' => 3,
                'linea_id' => 0,
                'grupo_id' => 0,
                'per_celular' => $request->data['celular'],
                'per_mail' => $request->data['email'],
                'per_ciudad' => strtoupper($request->data['ciudad']),
                'per_zona' => strtoupper($request->data['zona']),
                'per_calle' => strtoupper($request->data['calle']),
                'per_puerta' => $request->data['puerta'],
                'per_foto' => $fileName,

                'estado' => 1,
                'sysuser' => Auth::user()->id,
                'fechaRegistro' => $fecha
            ]);
            DB::commit();
            return response()->json(200);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json(400);
        }
        //return response()->json($request);
        return response()->json(200);
    }

    public function VerDatosPersonales(Request $request){
       $percodigo = $request->per_codigo;
        $tipoPersona = DB::table('personals')
            ->select('personals.tipoSocio_id')
            ->where('personals.per_codigo',$percodigo)
            ->first()->tipoSocio_id;
        if($tipoPersona == 3) {
            $datos = DB::table('personals')
            ->join('tipoSocios','personals.tipoSocio_id','tipoSocios.id')
            ->select('personals.per_codigo', 'personals.per_paterno', 'personals.per_materno',
                'personals.per_nombre','personals.per_fecha_nacimiento', 'personals.per_estado_civil',
                'personals.per_sexo','personals.per_ci','personals.per_expedido','personals.per_licencia',
                'personals.categoria_id', 'personals.tipoSocio_id','personals.per_celular','personals.per_mail',
                'personals.per_ciudad', 'personals.per_zona','personals.per_calle','personals.per_puerta',
                'personals.per_foto','personals.per_observaciones', 'personals.fechaRegistro','tipoSocios.descripcion')
                ->where('personals.per_codigo',$percodigo)
                ->first();
            return response()->json(['datos' => $datos]);

        }  else {
            $datos = DB::table('personals')
            ->join('tipoSocios','personals.tipoSocio_id','tipoSocios.id')
            ->join('categorias','personals.categoria_id','categorias.id')
            ->select(
                'personals.per_codigo',
                'personals.per_paterno',
                'personals.per_materno',
                'personals.per_nombre',
                'personals.per_fecha_nacimiento',
                'personals.per_estado_civil',
                'personals.per_sexo',
                'personals.per_ci',
                'personals.per_expedido',
                'personals.per_licencia',
                'personals.categoria_id',
                'personals.tipoSocio_id',
                'personals.linea_id',
                'personals.grupo_id',
                'personals.per_celular',
                'personals.per_mail',
                'personals.per_ciudad',
                'personals.per_zona',
                'personals.per_calle',
                'personals.per_puerta',
                'personals.per_foto',
                'personals.per_observaciones',
                'personals.fechaRegistro',
                'tipoSocios.descripcion')
                ->where('personals.per_codigo',$percodigo)
                ->first();
            return response()->json(['datos' => $datos]);
        }

    }

    public function EditarDatosPersonales(Request $request)
    {
        $personal = Personal::findOrFail($request->codigo);
        $currentPhoto = $personal->per_foto;
        if($request->per_foto != $currentPhoto){
            $exploded = explode(',', $request->per_foto);
            $decoded = base64_decode($exploded[1]);
            if (Str::contains($exploded[0], 'jpeg')) {
                $extension = 'jpg';
            } else {
                $extension = 'png';
            }
            $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
            $charactersLength = strlen($characters);
            $randomString = '';
            for ($i=0; $i < 10; $i++) { 
               $randomString .= $characters[rand(0,$charactersLength - 1)]; 
            }
            $fileName = $randomString.($request->ci).$randomString.'.'.$extension;
            $path = public_path().'/img/personal/'.$fileName;
            file_put_contents($path, $decoded);
            $request->per_foto=$fileName; 
        } 
        $sitper = DB::table('personals')
            ->where('per_codigo', $request->codigo)
            ->update([
                'per_paterno' => strtoupper($request->paterno), 
                'per_materno' => strtoupper($request->materno), 
                'per_nombre' => strtoupper($request->nombre), 
                'per_fecha_nacimiento' => $request->fechaNacimiento, 
                'per_estado_civil' => $request->estadoCivil,
                'per_sexo' => strtoupper($request->genero), 
                'per_ci' => $request->ci, 
                'per_expedido' => $request->expedido, 
             
                'per_celular' => $request->celular, 
                'per_mail' => $request->email,
          
                'per_ciudad' => strtoupper($request->per_ciudad), 
                'per_zona' => strtoupper($request->per_zona), 
                'per_calle' => strtoupper($request->per_calle), 

                'per_foto'  => $request->per_foto,
                'estado' => 1, 
                'sysuser' => Auth::user()->id
            ]);
        return response()->json([$sitper]);
    }

    public function createPDF(Request $request){
        //$conn = pg_pconnect('host=192.168.3.81 port=5432 dbname=sipefab_prod user=postgres password=4$Ku8&_d@B/9in*0w%');
        $conn = pg_pconnect("host=127.0.0.1 port=5432 dbname=transporte_db user=postgres password=7612120");
        $lista_persona = pg_query($conn,"SELECT personals.per_nombre, personals.per_paterno, personals.per_materno,
        personals.per_ci FROM personals
        ORDER BY  personals.per_paterno");
        $pdf = new PersonalController ('P','mm','Letter');
        $title = 'LISTADO DE PERSONAL';
        $pdf->SetTitle($title);
        $pdf->SetX(20);
        $pdf->AliasNbPages();
        $fecha = date("dHi-M-Y");
        $alias = '{nb}';
        $at = intval($alias) - 1;
        $pdf->Ln(5);
        global $p;
        global $orden;
        $orden = 'ascenso';
        global $pagina;
        $pdf->StartPageGroup();
        $pdf->AddPage();
        $pdf->SetY(20);
        $pdf->SetX(30);
        $pdf->Cell(166,239,'',1,0,'L');
        $pdf->SetY(21);
        $pdf->SetX(31);
        $pdf->Cell(164,237,'',1,0,'L');
        $pdf->SetFont('Arial','B',12);
        $pdf->SetY(30);
        $pdf->SetX(35);
        $pdf->Cell(86,5,utf8_decode('SINDICATO DE TRANSPORTE'),0,0,'C');
        $pdf->SetY(35);
        $pdf->SetX(35);
        $pdf->Cell(86,5,utf8_decode('16 DE JULIO TRUFI 7.'),0,0,'C');
        $pdf->SetFont('Arial','BU',12);
        $pdf->SetY(40);
        $pdf->SetX(35);
        $pdf->Cell(86,5,utf8_decode('BOLIVIA'),0,0,'C');
        $pdf->Image('./img/gallineta_sinfondo.png',40,50,146,80);
        $pdf->SetFont('Arial','B',30);
        $pdf->SetY(140);
        $pdf->SetX(30);
        $pdf->Cell(166,15,utf8_decode('ORDEN GENERAL'),0,0,'C');
        $pdf->SetY(155);
        $pdf->SetX(30);
        $pdf->Cell(166,15,utf8_decode('DE ASCENSOS'),0,0,'C');
        $pdf->SetFont('Arial','B',20);
        $pdf->SetY(190);
        $pdf->SetX(30);
        $gestion_abreviada = date("y");
        $pdf->Cell(166,15,utf8_decode('Nº 01/'.$gestion_abreviada),0,0,'C');
        $pdf->SetY(230);
        $pdf->SetX(30);
        $pdf->Ln();

        // $pdf->StartPageGroup();
        $pdf->StartPageGroup();
        $pdf->AddPage();
        $pdf->CreateIndex();


        $pdf->SetX(20);
        ob_clean();
        $pdf->SetX(20);
        $pdf->Output();
        $pdf->SetX(20);
        exit;
    }

    public function Memorandum(){
        $pdf = PDF::loadView('reportes.Memorandum')
        ->setPaper('letter', 'portrait');
        return $pdf->stream('Memorandum.pdf');
    }
}
