<?php

namespace App\Http\Controllers;

use App\TipoCuentas;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

class TipoCuentasController extends Controller
{
    public function index(Request $request){
        if (!$request->ajax()) return redirect('/');
        if ($request->buscar == '') {
            $tipoCuentas = TipoCuentas::orderBy('cuentaTipo')
            ->paginate(10);
        } else {
            $tipoCuentas = TipoCuentas::where('cuentaTipo','LIKE','%'.$request->buscar.'%')
                        ->orderBy('cuentaTipo')
                        ->paginate(10);
        }
        return response()->json([
            'pagination' => [
                'total'         => $tipoCuentas->total(),
                'current_page'  => $tipoCuentas->currentPage(),
                'per_page'      => $tipoCuentas->perPage(),
                'last_page'     => $tipoCuentas->lastPage(),
                'from'          => $tipoCuentas->firstItem(),
                'to'            => $tipoCuentas->lastItem(),

            ],
            'tipoCuentas' => $tipoCuentas
        ]);
    }

    public function store(Request $request){
        // return response()->json($request);
        if(!$request->ajax()) return redirect('/');
        $cuentaTipo = $request->cuentaTipo;
        $tipoCuentas = TipoCuentas::select('cuentaTipo')
        ->where('cuentaTipo', $cuentaTipo)
        ->first();
        //return response()->json($doc);
        if(!empty($tipoCuentas)){
            return response()->json("existe");
            //return "existe";
        } else {
            $tipoCuentas = new TipoCuentas();
            $tipoCuentas->cuentaTipo = $request->cuentaTipo;
            $val = $request->observacion;

            if($val == ''){
                $val = 'NINGUNO';
            }
            else{
                $val = $request->observacion;
            }
            $tipoCuentas->obs = $val;
            $tipoCuentas->estado = '1';
            $tipoCuentas->user_id = Auth::user()->id;
            $tipoCuentas->save();
        }
    }

    public function update(Request $request){
        if (!$request->ajax()) return redirect('/');
        //return response()->json($request);
        $id = $request->id;
        $cuentaTipo = $request->cuentaTipo;
        $tipoSocio = TipoCuentas::select('id','cuentaTipo')
        ->where('cuentaTipo', $cuentaTipo)
        ->whereNotIn('id', [$id])
        ->first();
        if(!empty($tipoSocio)){
            return response()->json("existe");
             //return "existe";
        } else {
            $tipoSocio = TipoCuentas::findOrFail($request->id);
            $tipoSocio->cuentaTipo = $request->cuentaTipo;
            $tipoSocio->obs = $request->observacion;
            $tipoSocio->estado = '1';
            $tipoSocio->user_id = Auth::user()->id;
            $tipoSocio->save();
        }
    }

    public function stateChange(Request $request){
        if(!$request->ajax()) return redirect('/');
        $tipoSocio           = TipoCuentas::findOrFail($request->id);
        $tipoSocio->estado   = $request->estado;
        $tipoSocio->save();
    }

    public function selectTipCuenta(Request $request)
    {
        if(!$request->ajax()) return view('/');

        $tipoCuentas = DB::table('cuentaTipos')
                            ->select('id as idcuentaTipos','cuentaTipo','obs','estado','user_id')
                            ->orderBy('id','asc')
                            ->get();
        return response()->json($tipoCuentas);
    }
}
