<?php

namespace App\Http\Controllers;

use App\TipoSocio;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

class TipoSocioController extends Controller
{
    public function index(Request $request){
        if (!$request->ajax()) return redirect('/');
        if ($request->buscar == '') {
            $tipoSocios = TipoSocio::where('estado','1')
            ->orderBy('descripcion')
            ->paginate(10);
        } else {
            $tipoSocios = TipoSocio::where('descripcion','LIKE','%'.$request->buscar.'%')
                        ->orderBy('descripcion')
                        ->paginate(10);
        }
        return response()->json([
            'pagination' => [
                'total'         => $tipoSocios->total(),
                'current_page'  => $tipoSocios->currentPage(),
                'per_page'      => $tipoSocios->perPage(),
                'last_page'     => $tipoSocios->lastPage(),
                'from'          => $tipoSocios->firstItem(),
                'to'            => $tipoSocios->lastItem(),

            ],
            'tipoSocios' => $tipoSocios
        ]);
    }

    public function store(Request $request){
        // return response()->json($request);
        if(!$request->ajax()) return redirect('/');
        $descripcion = $request->descripcion;
        $tipoSocio = TipoSocio::select('descripcion')
        ->where('descripcion', $descripcion)
        ->first();
        //return response()->json($doc);
        if(!empty($tipoSocio)){
            return response()->json("existe");
              //return "existe";
        } else {
            $tipoSocio = new TipoSocio();
            $tipoSocio->descripcion = $request->descripcion;
            $tipoSocio->propietario = '0';
            $tipoSocio->obs = $request->observacion;
            $tipoSocio->estado = '1';
            $tipoSocio->user_id = Auth::user()->id;
            $tipoSocio->save();
        }
    }

    public function update(Request $request){
        if (!$request->ajax()) return redirect('/');
        //return response()->json($request);
        $id = $request->id;
        $descripcion = $request->descripcion;
        $tipoSocio = TipoSocio::select('id','descripcion')
        ->where('descripcion', $descripcion)
        ->whereNotIn('id', [$id])
        ->first();
        if(!empty($tipoSocio)){
            return response()->json("existe");
             //return "existe";
        } else {
            $tipoSocio = TipoSocio::findOrFail($request->id);
            $tipoSocio->descripcion = $request->descripcion;
            $tipoSocio->obs = $request->observacion;
            $tipoSocio->estado = '1';
            $tipoSocio->user_id = Auth::user()->id;
            $tipoSocio->save();
        }
    }

    public function stateChange(Request $request){
        if(!$request->ajax()) return redirect('/');
        $tipoSocio           = TipoSocio::findOrFail($request->id);
        $tipoSocio->estado   = $request->estado;
        $tipoSocio->save();
    }

    public function selectTipoSocio(Request $request)
    {
        if(!$request->ajax()) return view('/');
        $tipoSocios = DB::table('tipoSocios')
                            ->select('id as tipoSocio_id','descripcion','propietario','obs','estado','user_id')
                            ->where('estado','1')
                            ->orderBy('descripcion','asc')
                            ->get();
        //return var_dump($tipoSocios);
        return response()->json($tipoSocios);
    }
}
