<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Personal;
use App\Mail\Usuario;
use App\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use PHPUnit\Framework\MockObject\Stub\ReturnReference;

class UsuarioController extends Controller
{
    public function datosP(){
        $datos = DB::table('users')
            ->join('personals','users.percod','personals.per_codigo')
            ->select('personals.per_nombre as nombre','personals.per_paterno as paterno','personals.per_materno as materno','personals.per_foto')
            ->where('personals.per_codigo',Auth::user()->percod)
            ->where('personals.estado',1)
            ->where('users.estado',1)
            ->first();

            return response()->json($datos);
    }

    public function DatosUsuario() {

        $usuario = DB::table('users as u')
            ->join('personals as p','u.percod','p.per_codigo')
            ->join('roles','u.idrol','roles.id')
            ->select('u.id','u.estado','u.email','p.per_nombre as nombre','p.per_paterno as paterno',
                    'p.per_materno as materno','p.per_foto as foto','p.per_celular as celular',
                    'p.per_ci as ci','p.per_expedido as expedido', 'roles.name')
            ->where('p.estado',1)
            ->where('u.estado',1)
            ->where('u.id',Auth::user()->id)
            ->first();

        return response()->json($usuario);
    }

    public function ListarUsuarios(Request $request){
        $buscar = $request->buscar;
        if ($buscar == '') {
            $usuarios = DB::table('users as u')
            ->join('personals as p','u.percod','p.per_codigo')
            ->join('model_has_roles as mr', 'u.id','mr.model_id')
            ->join('roles as r','mr.role_id','r.id')
            ->select('u.id','u.estado','p.per_nombre as nombre',
                    'p.per_paterno as paterno','p.per_materno as materno',
                    'p.per_ci as ci','r.name as role', 'r.id as rolId','u.email'
                    )
            ->orderBy('u.id','desc')
            ->paginate(10);
        } else {
            $usuarios =  DB::table('users as u')
            ->join('personals as p','u.percod','p.per_codigo')
            ->join('model_has_roles as mr', 'u.id','mr.model_id')
            ->join('roles as r','mr.role_id','r.id')
            ->select('u.id','u.estado','p.per_nombre as nombre',
                    'p.per_paterno as paterno','p.per_materno as materno',
                    'p.per_ci as ci','r.name as role', 'r.id as rolId' ,'u.email'
                    )
            ->where(function($q) use ($buscar){
                $q->where('p.per_paterno','LIKE','%'.$buscar.'%')
                ->orWhere('p.per_ci','LIKE','%'.$buscar.'%')
                ->orWhere('p.per_nombre','LIKE','%'.$buscar.'%')
                ->orWhere('p.per_materno','LIKE','%'.$buscar.'%');
            })

            ->orderBy('u.id','desc')
            ->paginate(10);

        }

        return response()->json([
            'pagination' => [
                'total'         => $usuarios->total(),
                'current_page'  => $usuarios->currentPage(),
                'per_page'      => $usuarios->perPage(),
                'last_page'     => $usuarios->lastPage(),
                'from'          => $usuarios->firstItem(),
                'to'            => $usuarios->lastItem(),

            ],
            'usuarios' => $usuarios
        ]);
    }

    public function AgregarUsuario(Request $request){
        $buscar = $request->buscarA;
        $personal =  DB::table('personals')
        ->select('personals.per_codigo','personals.per_nombre',
                'personals.per_paterno','personals.per_materno',
                'personals.per_ci','personals.per_mail'
                )
        ->where(function($q) use ($buscar){
            $q->where('personals.per_paterno','LIKE','%'.$buscar.'%')
            ->orWhere('personals.per_ci','LIKE','%'.$buscar.'%')
            ->orWhere('personals.per_nombre','LIKE','%'.$buscar.'%')
            ->orWhere('personals.per_materno','LIKE','%'.$buscar.'%');
        })->get();

        return[

            'newUser' => $personal,
            'code'=>200
        ];
    }

    public function DatosUsuarios(Request $request){
        $id = $request->id;
        $usuarios = DB::table('users as u')
        ->join('personals as p','u.percod','p.per_codigo')
        ->select('u.id','u.estado','p.per_nombre as nombre','p.per_paterno as paterno',
                'p.per_materno as materno','p.per_foto as foto', 'p.per_ci as ci','p.per_expedido as expedido','p.per_mail'
                )

            ->where('u.id',$id)
            ->first();
        $rol = DB::table('model_has_roles as mr')
            ->join('roles as r','mr.role_id','r.id')
            ->select('r.id','r.name')
            ->where('mr.model_id',$id)
            ->first();
        return response()->json(['usuarios'=>$usuarios,'role'=>$rol]);
    }

    public function EditarUsuario(Request $request){
        $id = $request->id;
        $password = $request->password;
        $user = User::find($id);

        if ($password != '') {
            DB::table('users')
            ->where('id',$id)
            ->update([
                'password' => Hash::make($password)
            ]);
        }

        $user->removeRole($request->rolAn);
        $user->assignRole($request->rolNu);

        return response()->json($request);
    }

    public function DesactivarUsuario(Request $request){
        $usuario = User::findOrFail($request->id);
        $usuario->estado = '0';
        $usuario->save();
    }

    public function ActivarUsuario(Request $request){
        $usuario = User::findOrFail($request->id);
        $usuario->estado = '1';
        $usuario->save();
    }

    public function EditContrasena(Request $request){
        $u = DB::table('users')
            ->select('password')
            ->where('id',Auth::user()->id)
            ->first();
        if (Hash::check($request->contrasenaA, $u->password)) {
            DB::table('users')
                ->where('id',Auth::user()->id)
                ->update([
                    'password' => Hash::make($request->contrasena)
                ]);
            Auth::logout();
            $code = 200;
            return response()->json($code);
        } else {
            $code = 400;
            return response()->json($code);
        }


    }

    public function store(Request $request){
        //  return response()->json($request->rolId);
        if(!$request->ajax()) return redirect('/');

        $usuario = $request->PersonaAgre;
        $per_codigo = $usuario[0]['per_codigo'];
        $per_mail = $usuario[0]['per_mail'];
        $personals = Personal::select('personals.per_codigo',
                    'personals.per_paterno',
                    'personals.per_nombre',
                    'personals.per_materno',
                    'personals.per_ci',
                    'personals.per_mail')

            ->where('personals.per_codigo',$per_codigo)
            ->first();
          // Generador de Contraseña aleatoria
        $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i=0; $i < 10; $i++) {
            $randomString .= $characters[rand(0,$charactersLength - 1)];
        }
        $usuario = User::select('percod')
        ->where('percod', $per_codigo)
        ->first();
        if(!empty($usuario)){
            return response()->json(201);
        } else {
            try {
                DB::beginTransaction();
                $user = User::create([
                    'percod'        => $per_codigo,
                    'idrol'         =>  $request->role,
                    'email'         =>  $per_mail,
                    'password'      => '$2y$10$TNrE3Ev.qv.tgMwpX4bAXO3M7UuDvXv97T3x/vqsAryjqrwv4biNe', //Hash::make($randomString),
                    'estado'        => '1',
                    'sysuser'       => Auth::user()->id
                ]);
                $user->assignRole($request->rol);
                DB::commit();
              //  Mail::to($personals->per_mail)
               // ->send(new Usuario($personals, $randomString));
                return response()->json(200);
            } catch (\Throwable $e) {
                DB::rollBack();  // PARA RETROCEDES UN PASO ATRAS
               return response()->json(400);
            }

            return response()->json("200");
        }

    }
}
